var flipShown = false;

var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, elements:[], timer:null};


//  Returns val if min < val < max
//  Returns min if val <= min
//  Returns max if val >= max

function limit_3 (val, min, max)
{
    return val < min ? min : (val > max ? max : val);
}

function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

function animate()
{
        var T;
        var ease;
        var time = (new Date).getTime();
                
        
        T = limit_3(time-animation.starttime, 0, animation.duration);
        
        if (T >= animation.duration)
        {
                clearInterval (animation.timer);
                animation.timer = null;
                animation.now = animation.to;
        }
        else
        {
                ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
                animation.now = computeNextFloat (animation.from, animation.to, ease);
        }
        
        for (var i = 0; i < animation.elements.length; i++) {
            animation.elements[i].style.opacity = animation.now;
        }
}


function mousemove (event)
{
        if (!flipShown)
        {
                // fade in the flip widget
                if (animation.timer != null)
                {
                        clearInterval (animation.timer);
                        animation.timer  = null;
                }
                
                var starttime = (new Date).getTime() - 13; // set it back one frame
                
                animation.duration = 500;
                animation.starttime = starttime;
                animation.elements = [document.getElementById ('flipl'), document.getElementById ('flipr')];
                animation.timer = setInterval ("animate();", 13);
                animation.from = animation.now;
                animation.to = .70;
                animate();
                flipShown = true;
        }
}

function mouseexit (event)
{
        if (flipShown)
        {
                // fade in the flip widget
                if (animation.timer != null)
                {
                        clearInterval (animation.timer);
                        animation.timer  = null;
                }
                
                var starttime = (new Date).getTime() - 13; // set it back one frame
                
                animation.duration = 500;
                animation.starttime = starttime;
                animation.elements = [document.getElementById ('flipl'), document.getElementById ('flipr')];
                animation.timer = setInterval ("animate();", 13);
                animation.from = animation.now;
                animation.to = 0.0;
                animate();
                flipShown = false;
        }
}